#include <Keypad.h>

/**
   On précise le nombre de ligne et de colonne
*/
const byte ROWS = 4;
const byte COLS = 4;

/**
   Il faut créer un tableau afin de représenter notre clavier
*/
char keyboard[ROWS][COLS] = {
  {'1', '2', '3', 'A'},
  {'4', '5', '6', 'B'},
  {'7', '8', '9', 'C'},
  {'*', '0', '#', 'D'}
};

/**
   Ici on initilise les PINS de l'ARDUINO
*/
byte rowPins[ROWS] = {9, 8, 7, 6};
byte colPins[COLS] = {5, 4, 3, 2};

/**
   On utilise notre librairie pour déclarer le clavier
   et on lui donne un nom captainKeypad
*/
Keypad captainKeypad = Keypad(makeKeymap(keyboard), rowPins, colPins, ROWS, COLS);


/**
   Maintenant on va préparer les éléments pour le mot de passe
*/

/**
   Le mot de passe et sa longueur
   On utilise des constantes car les 2 valeurs là ne doivent jamais bouger !
*/
const String captainPasswordHigh = "22*"; // Le mot de passe
const int passwordLength = captainPasswordHigh.length(); // La longueur du mot de passe (3 caractères pour notre exemple) la fonction length() donne la taille de la chaîne de caractères

String userPassword; // On prépare la variable qui va conserver ce que l'utilisateur va taper

bool passwordIsGood; // Variable boolean : true ou false pour dire si le mot de passe est bon ou non
char currentKey; // La valeur que l'utilisateur va taper

int testPassword = 0; // Nombre de tentative de l'utilisateur
int limitTest = 3; // Maximum de tentative possible

/**
   on termine en préparant nos 2 leds
*/
int ledSuccess = 13;
int ledError = 11;

/**
   Et on pense au bouton :)
*/
const int buttonPin = 12;

/**
  Sans oublier notre buzzer
*/
const int buzzer = 10;

void setup() {
  Serial.begin(9600);

  /**
     On initialise les Leds en OUTPUT car on va leur envoyer des valeurs pour les allumer ou non
  */
  pinMode(ledSuccess, OUTPUT);
  pinMode(ledError, OUTPUT);

  /**
     Et le bouton en INPUT car on va lire la donnée
  */
  pinMode(buttonPin, INPUT);

  /**
    Le buzzer est lui aussi un OUTPUT car on donne ou retire du courant
  */
  pinMode(buzzer, OUTPUT);

  // un message pour informer ce qu'on doit faire
  Serial.println("Entrer le mot de passe de Captain Arduino :");
}

void loop() {
  /**
     On débute par lire le bouton
     Clique ? ou pas clique ?
     Au clique on reset nos données
  */
  if (digitalRead(buttonPin) == HIGH) {
    Serial.println("Réinitialisation !");
    userPassword = "";
    testPassword = 0;
    digitalWrite(buzzer, LOW); // On éteint ce satané buzzer :D
    return;
  }

  /**
     Est-ce qu'on a atteint la limite de teste
     Si oui, on affiche un message et on fait clignoter la LED ledError (dans la vidéo : la LED rouge)
  */
  if (testPassword == limitTest) {
    Serial.println("Verrouillage du système, déclenchement de l'alarme !");
    digitalWrite(buzzer, HIGH);
    digitalWrite(ledError, HIGH);
    delay(300);
    digitalWrite(ledError, LOW);
    delay(300);
    return; // Le return sert à bloquer le script, on retourne à chaque fois en haut de la boucle et de ce fait la suite n'est plus exécuté
  }

  /**
     On récupère la valeur du clavier et on l'ajoute à notre variable
     L'ajout dans le Serial est juste là afin de visualiser ce qu'il se passe
  */
  currentKey = captainKeypad.getKey();
  if (currentKey != NO_KEY) {
    userPassword += currentKey;
    Serial.println(userPassword);
  }

  /**
     Si la longueur de mot de passe de l'utilisateur est égale à la longueur de notre mot de passe on rentre dans la boucle
     Sinon, on repart en haut de la boucle
     la fonction length() permet d'avoir la taille du chaîne de caractères
  */
  if (userPassword.length() == passwordLength) {
    /*
       On incrémente la variable : le nombre de fois qu'on a tenté un mot de passe
       Cette syntaxe testPassword++ est identique à celle-ci : testPassword = testPassword + 1;
    */
    testPassword++;

    /**
       La fonction equalsIgnoreCase() permet de savoir si le string qu'on teste (ici le mot de passe de l'utilisateur userPassword) est égale à notre mot de passe
       Cette fonction est insensible à la casse

       Si on est bon, victoire :) LED verte signalant qu'on peut entrer
       On pourrait imaginer que cela désactive l'alarme
    */
    if (captainPasswordHigh.equalsIgnoreCase(userPassword)) {
      Serial.println("Correct");
      digitalWrite(ledSuccess, HIGH);
      delay(2000);
      digitalWrite(ledSuccess, LOW);
      testPassword = 0; // on pense à reset le nombre de test
    }
    else {
      /**
         Si le mot de passe est faux
         On a la LED rouge et on affiche un texte
         Et tant qu'on a pas atteint le nombre maximum de tentative, on affiche un second message
      */
      Serial.println("Incorrect");
      if (testPassword < 3) {
        Serial.println("Entrer le mot de passe de Captain Arduino :");
      }
      digitalWrite(ledError, HIGH);
      delay(2000);
      digitalWrite(ledError, LOW);
    }

    /**
       Après une tentative de mot de passe il faut reset la variable
    */
    userPassword = "";
  }
}
