#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>

// Le pin que l'on va utiliser (sur un ESP 01S) il y a 2 pins : 0 et 2
int pinGPIO0 = 0;

// Permet de lancer le serveur sur le port 80
ESP8266WebServer server(80);

/*
 * Configuration de votre accès WIFI :
 * SSID + Mot de passe
 */
char* ssid = "Captain-arduino"; // à remplacer par vos infos
char* password = "42"; // à remplacer par vos infos

/**
 * J’initialise une variable pour la suite :)
 */
String result = "";

void setup()
{
  /**
   * On tente de se connecter au wifi
   */
  WiFi.begin(ssid, password);
  Serial.begin(9600);
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(500);
  }
  // Ici on est connecté au wifi
  // Et on affiche le tout dans le moniteur série : ainsi que l'adresse IP locale de votre ESP
  // Une adresse IP locale c'est par exemple ceci : 192.168.1.42 (pour vous ça peut être 192.168.1.10, 192.168.1.9, 192.168.1.78, etc.)
  Serial.println("");
  Serial.print("IP Address: ");
  Serial.println(WiFi.localIP());

  pinMode(pinGPIO0, OUTPUT); // le pinMode output car on va envoyer une donnée
  digitalWrite(pinGPIO0, LOW); // par défaut on éteint la led

/**
 * Configuration des routes
 */
  server.on("/", HTTP_GET, viewIndex); // return un text/plain : du simple texte
  server.on("/web", HTTP_GET, viewWeb); // return un entête html et une page entière html 
  server.on("/led", HTTP_GET, viewLed); // return du json 
  server.on("/led", HTTP_POST, updateLed); // return un text/plain : du texte là aussi (le mieux serait de retourner du json)
  
  server.onNotFound(viewNotFound); // Il faut penser aux urls qui n'existent pas (les 404)

  // Lancement du serveur
  server.begin();
}

void loop()
{
  /**
     ceci permet d'écouter les requêtes HTTP afin de charger ce qu'on a configuré dans le setup
  */
  server.handleClient();
}

// Le classique Hello World :)
void viewIndex() {
  server.send(200, "text/plain", "Hello world!");
}

/*
 * La page web : c'est affreux on est bien d'accord 
 * On l'obtient lorsqu'on ira sur cette route (avec une methode GET) : [votre_IP]/web par exemple : http://192.168.1.42/web
 */
void viewWeb() {
  
  String renderHtml = "<!DOCTYPE html><html lang='fr'>";
  
  renderHtml += "<head><meta charset='UTF-8'>";
  renderHtml += "<title>Captain Arduino</title>";
  server.send(200, "text/html", "<!DOCTYPE html><html lang='fr'><head><meta charset='UTF-8'><title>Captain Arduino</title><style>body{background: #000;color:#fff;text-align: center;}button{border: 0; padding: 5px 20px; text-transform: uppercase; cursor: pointer;}.show-led:hover, .show-led.current{background: green;color: #fff;}.hide-led:hover, .hide-led.current{background: red;color: #fff;}</style></head><body><h1>L'ESP8266 - 01s avec Captain Arduino</h1><div class='wrapper'><div class=\"content\"><button class='show-led' onclick=\"configLed(1, `show-led`)\"></button><button class='hide-led' onclick=\"configLed(0, `hide-led`)\"></button><div class='error'></div></div></div><script>var options={method: 'GET', headers:{'Content-Type': 'application/x-www-form-urlencoded; charset=utf-8'},}; fetch('http://192.168.1.42/led', options).then((resp)=> resp.json()) .then(data=>{if (data.currentLed){document.getElementsByClassName('show-led')[0].classList.add('current');document.getElementsByClassName('hide-led')[0].classList.remove('current');document.getElementsByClassName('show-led')[0].innerHTML='La led est allumée';document.getElementsByClassName('hide-led')[0].innerHTML='éteindre la led';}else{document.getElementsByClassName('hide-led')[0].classList.add('current');document.getElementsByClassName('show-led')[0].classList.remove('current');document.getElementsByClassName('hide-led')[0].innerHTML='La led est éteinte';document.getElementsByClassName('show-led')[0].innerHTML='allumer la led';}});function configLed(led, classNameLed){var data='show=' + led;var options={method: 'POST', headers:{'Content-Type': 'application/x-www-form-urlencoded; charset=utf-8'}, body: data,}; [].forEach.call(document.getElementsByTagName('button'), function(el){el.classList.remove('current');});fetch('http://192.168.1.42/led', options) .then(res=>{if (res.ok){document.getElementsByClassName(classNameLed)[0].classList.add('current');if(led){document.getElementsByClassName('show-led')[0].classList.add('current');document.getElementsByClassName('hide-led')[0].classList.remove('current');document.getElementsByClassName('show-led')[0].innerHTML='La led est allumée';document.getElementsByClassName('hide-led')[0].innerHTML='éteindre la led';}else{document.getElementsByClassName('hide-led')[0].classList.add('current');document.getElementsByClassName('show-led')[0].classList.remove('current');document.getElementsByClassName('hide-led')[0].innerHTML='La led est éteinte';document.getElementsByClassName('show-led')[0].innerHTML='allumer la led';}}else{document.getElementsByClassName('error').innerHTML='Une erreur survenue. Merci de réessayer';}}) .catch(error=>{document.getElementsByClassName('error').innerHTML='Une erreur survenue ('+error+'). Merci de réessayer';});}</script></body></html>");
}

/**
 * Fonction permettant de savoir si la led est allumé ou éteinte
 * Dans le HTML de la fonction viewWeb() j'ai mis en place un appel fetch (javascript) afin d'appeler cette route (avec une methode GET) : [votre_IP]/led par exemple : http://192.168.1.42/led
 * Cette fonction retourne un format json pour dire 0 ou 1 si la led est éteinte ou allumé
 */
void viewLed() {
  int currentLed = 0;
  /**
   * On récupère l'info du PIN : HIGH ou LOW donc 1 ou 0
   * Si on est HIGH => cela signifie que la LED est allumé, donc la variable currentLed passe à 1
   * Sinon on fait rien car la variable currentLed est déjà à 0
   */
  if (digitalRead(pinGPIO0)) {
    currentLed = 1;
  }

/**
 * Configuration de la variable JSON pour le return
 */
  String messageResponse = "\"currentLed\":\n";
  messageResponse += currentLed;

/**
 * Access-Control-Allow-Origin est très IMPORTANT ! 
 * Cela renvoie une réponse indiquant si les ressources peuvent être partagées avec une origine donnée
 * Dans notre cas, je lui dit : tu partages avec tout le monde
 */
  server.sendHeader("Access-Control-Allow-Origin", "*");
  server.send(200, "application/json", "{" + messageResponse + "}");
}

/**
 * Mise à jour de la led
 */
void updateLed() {
  // hasArg
  if (server.arg("show") == "1") {
    digitalWrite(pinGPIO0, HIGH);
    result = "show test";
  } else {
    digitalWrite(pinGPIO0, LOW);
    result = "hide test";
  }
  server.sendHeader("Access-Control-Allow-Origin", "*");
  server.send(200, "text/plain", result);
}

/**
 * Gestion des 404 : un simple texte
 */
void viewNotFound() {
  server.send(404, "text/plain", "404: Not found");
}
