#include <Keypad.h>

/**
 * On précise le nombre de ligne et de colonne
 */
const byte ROWS = 4; 
const byte COLS = 4; 

/**
 * Il faut créer un tableau afin de représenter notre clavier
 */
char keyboard[ROWS][COLS] = {
  {'1', '2', '3', 'A'},
  {'4', '5', '6', 'B'},
  {'7', '8', '9', 'C'},
  {'*', '0', '#', 'D'}
};

/**
 * Ici on initilise les PINS de l'ARDUINO
 */
byte rowPins[ROWS] = {9, 8, 7, 6}; 
byte colPins[COLS] = {5, 4, 3, 2}; 

/**
 * On utilise notre librairie pour déclarer le clavier 
 * et on lui donne un nom captainKeypad 
 */
Keypad captainKeypad = Keypad(makeKeymap(keyboard), rowPins, colPins, ROWS, COLS); 

void setup(){
  Serial.begin(9600);
}
  
void loop(){
  /**
   * A chaque fois qu'on appuie sur une touche du clavier, 
   * On récupère la valeur
   */
  char currentKey = captainKeypad.getKey();

  /**
   * Si on a appuie et qu'on a quelque chose on affiche dans le moniteur série la valeur
   */
  if (currentKey != NO_KEY){
    Serial.println(currentKeyKey);
  }
}
