/**
 * Initialisation des LEDs sur chaque PIN Digital
 */

const int LED11 = 11;
const int LED10 = 10;
const int LED9 = 9;
const int LED8 = 8;
const int LED7 = 7;
const int LED6 = 6;

/**
 * Initialisation des pinMode() en mode output car on va envoyer des infos à chaque LED
 */
void setup()
{
  pinMode(LED11, OUTPUT);
  pinMode(LED10, OUTPUT);
  pinMode(LED9, OUTPUT);
  pinMode(LED8, OUTPUT);
  pinMode(LED7, OUTPUT);
  pinMode(LED6, OUTPUT);
}

void loop()
{
/**
 * On met en place une boucle pour passer sur chaque LED de 6 à 11 (inclut)
 * Et on exécute notre fonction
 */
  for(int i=6; i<= 11; i++){
    blinkLed(i, 200);
  }
/**
 * On procède ensuite au sens inverse afin d'avoir notre effet correctement
 */
  for(int i=11; i>= 6; i--){
    blinkLed(i, 200);
  }
}

/**
 * Création d'une fonction avec 2 paramètres : le numéro de la PIN et le delay
 * La fonction est simple : allume la PIN N°X - attend X millisecondes - éteint la PIN N°X
 */
void blinkLed(int pin, int duration){
  digitalWrite(pin, HIGH);
  delay(duration);
  digitalWrite(pin, LOW);
}
