#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>

// ajout de la lib DHT
#include <DHT.h>
// création d'une constante qui aura pour nom DHTTYPE et pour valeur DHT22
#define DHTTYPE DHT22

// initialisation de la PIN qui recoit les datas de notre module
// dans mon cas, la PIN digital 7
const int DHT22_PIN = D7;

// Le pin que l'on va utiliser pour notre Led
const int LED_PIN = D1;

// Permet de lancer le serveur sur le port 80
ESP8266WebServer server(80);

// initialisation de la class DHT22 via le mot clé DHT
// dht minuscule est simplement le nom que je lui donne, on pourrait l'appeler captain sans souci :) mais plus le code est clair et plus la lecture sera simple
// en paramètre, la PIN et la lib
DHT dht(DHT22_PIN, DHTTYPE);


#ifndef STASSID
#define STASSID "Captain"
#define STAPSK  "arduino"
#endif

/**
 * J’initialise des variables pour la suite :)
 */
int result = 0;
unsigned int raw=0;
float volt=0.0;

// R1 : 470K
// R2 : 1M

const float coeff_pont = 0.68; // R2 / ( R1 + R2 ) R1 et R2 en ohms


const float TensionAnalog = 3.2;

void setup() {
  /**
   * on force l'IP Fixe et on tente de se connecter au Wifi
   */
  IPAddress ip(192, 168, 1, 97);
  IPAddress dns(192,168,1,254);
  IPAddress gateway(192,168,1,254);
  IPAddress subnet(255, 255, 255, 0);

  WiFi.config(ip, dns, gateway, subnet);
  
  WiFi.begin(STASSID, STAPSK);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
  }
  pinMode(A0, INPUT);
  pinMode(LED_PIN, OUTPUT);
  dht.begin();

  /**
 * Configuration des routes
 */
  server.on("/dht", HTTP_GET, viewDht); // retourne les données du capteur au format json
  server.on("/led", HTTP_GET, viewLed); // retourne l'état de la led au format json
  server.on("/volt", HTTP_GET, viewVolt); // retourne l'état de la batterie
  server.on("/led", HTTP_POST, updateLed); // permet de modifier l'état de la led et retourne le nouvel état au format json
  
  server.onNotFound(viewNotFound); // Il faut penser aux urls qui n'existent pas (les 404)

  // Lancement du serveur
  server.begin();
}

void loop() {
    

  if ((WiFi.status() == WL_CONNECTED)) {
      server.handleClient();
  
  }
  
  delay(500);
}


/**
 * Gestion des 404 : un simple texte
 */
void viewNotFound() {
  server.send(404, "text/plain", "404: Not found");
}

/**
 * 
 */
void viewVolt() {
  
    raw = analogRead(A0); 
    float tension_bat = ((raw * ( TensionAnalog / 1024)) / coeff_pont);

  /**
 * Configuration de la variable JSON pour le return
 */
  String messageResponse = "\"voltage\":\n";
  messageResponse += String(tension_bat) ;
  

/**
 * Access-Control-Allow-Origin est très IMPORTANT ! 
 * Cela renvoie une réponse indiquant si les ressources peuvent être partagées avec une origine donnée
 * Dans notre cas, je lui dit : tu partages avec tout le monde
 */
  server.sendHeader("Access-Control-Allow-Origin", "*");
  server.send(200, "application/json", "{" + messageResponse + "}");
}

/**
 * Mise à jour de la led
 */
void updateLed() {

  // si le paramètre qu'on a envoyé (show) vaut on allume sinon on éteind
  if (server.arg("show") == "1") {
    digitalWrite(LED_PIN, HIGH);
    result = 1;
  } else {
    digitalWrite(LED_PIN, LOW);
    result = 0;
  }

  /**
 * Configuration de la variable JSON pour le return
 */
  String messageResponse = "\"currentLed\":\n";
  messageResponse += result;
  

/**
 * Access-Control-Allow-Origin est très IMPORTANT ! 
 * Cela renvoie une réponse indiquant si les ressources peuvent être partagées avec une origine donnée
 * Dans notre cas, je lui dit : tu partages avec tout le monde
 */
  server.sendHeader("Access-Control-Allow-Origin", "*");
  server.send(200, "application/json", "{" + messageResponse + "}");
}

/**
 * Fonction permettant de savoir si la led est allumé ou éteinte
 * Dans le HTML de la fonction viewWeb() j'ai mis en place un appel fetch (javascript) afin d'appeler cette route (avec une methode GET) : [votre_IP]/led par exemple : http://192.168.1.42/led
 * Cette fonction retourne un format json pour dire 0 ou 1 si la led est éteinte ou allumé
 */
void viewLed() {
  int currentLed = 0;
  /**
   * On récupère l'info du PIN : HIGH ou LOW donc 1 ou 0
   * Si on est HIGH => cela signifie que la LED est allumé, donc la variable currentLed passe à 1
   * Sinon on fait rien car la variable currentLed est déjà à 0
   */
  if (digitalRead(LED_PIN)) {
    currentLed = 1;
  }

/**
 * Configuration de la variable JSON pour le return
 */
  String messageResponse = "\"currentLed\":\n";
  messageResponse += currentLed;

/**
 * Access-Control-Allow-Origin est très IMPORTANT ! 
 * Cela renvoie une réponse indiquant si les ressources peuvent être partagées avec une origine donnée
 * Dans notre cas, je lui dit : tu partages avec tout le monde
 */
  server.sendHeader("Access-Control-Allow-Origin", "*");
  server.send(200, "application/json", "{" + messageResponse + "}");
}


/**
 * Fonction permettant de récupérer les données du capteur de température
 */
void viewDht() {
   float h = dht.readHumidity(); 
   float t = dht.readTemperature(); 
   

/**
 * Configuration de la variable JSON pour le return
 */
  String messageResponse = "\"temperature\":\n";
  messageResponse += String(t);
  messageResponse += ",\"humi\":\n";
  messageResponse += String(h);
          


/**
 * Access-Control-Allow-Origin est très IMPORTANT ! 
 * Cela renvoie une réponse indiquant si les ressources peuvent être partagées avec une origine donnée
 * Dans notre cas, je lui dit : tu partages avec tout le monde
 */
  server.sendHeader("Access-Control-Allow-Origin", "*");
  server.send(200, "application/json", "{" + messageResponse + "}");
}
