// ajout de la lib DHT
#include <DHT.h>
// création d'une constante qui aura pour nom DHTTYPE et pour valeur DHT11
#define DHTTYPE DHT11

// initialisation de la PIN qui recoit les datas de notre module
// dans mon cas, la PIN digital 7
const int TEMP_PIN = 7;

// initialisation de la class DHT11 via le mot clé DHT
// dht minuscule est simplement le nom que je lui donne, on pourrait l'appeler captain sans souci :) mais plus le code est clair et plus la lecture sera simple
// en paramètre, la PIN et la lib
DHT dht(TEMP_PIN, DHTTYPE);

void setup() {
  Serial.begin(9600);

  // syntaxe trouvée sur le arduino.cc
  // elle permet d'attendre que l
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB
  }

  // permet de démarrer la lecture des données
  dht.begin();
}

void loop() {

  // on attend 2secondes avant notre première lecture
  // cela permet au module de charger correctement et cela évite des erreurs
  delay(2000);
  
  // lecture de l'humidité
  float h = dht.readHumidity(); 
  
  // lecture de la température en degré celsius (c'est l'option par défaut) 
  float t = dht.readTemperature(); 
  
  // pour lire en degré Fahrenheit il faut ajouter en paramètre de la fonction le boolean true)
  float f = dht.readTemperature(true);

  // petite vérification que l'on a bien une donnée.
  // isnan() permet de vérifier si la valeur n'est pas un nombre
  // dans notre cas si un des trois résultats n'est pas un nombre, on rentre dans la condition
  // une fois dans la condition, un petit message d'error et on arrête tout grâce au mot clé : return
  // on retourne sur le début de la boucle pour lire à nouveau les données
  if (isnan(h) || isnan(t) || isnan(f)) {
    Serial.println("Erreur de lecture du capteur DHT !");
    return;
  }

  // on termine en affichant les résultats
  // String() permet de convertir notre variable en string afin de pouvoir la concaténer sans souci 
  Serial.println("Humidité : " + String(h) + "%");
  Serial.println("Température : " + String(t) + "°C");
}
