// ajout de la lib DHT
#include <DHT.h>
// création d'une constante qui aura pour nom DHTTYPE et pour valeur DHT22
#define DHTTYPE DHT22

// initialisation de la PIN qui recoit les datas de notre module
// dans mon cas, la PIN digital 7
const int TEMP_PIN = 7;

/**
 * Initialisation du PIN Digital
 */
const int RELAY = 2;

// initialisation de la class DHT11 via le mot clé DHT
// dht minuscule est simplement le nom que je lui donne, on pourrait l'appeler captain sans souci :) mais plus le code est clair et plus la lecture sera simple
// en paramètre, la PIN et la lib
DHT dht(TEMP_PIN, DHTTYPE);

void setup() {
  Serial.begin(9600);

  // syntaxe trouvée sur le arduino.cc
  // elle permet d'attendre que le serial soit disponible
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB
  }

  // permet de démarrer la lecture des données
  dht.begin();

/**
   * Initialisation des pinMode() en mode output car on va envoyer du courant ou non
   */
  pinMode(RELAY, OUTPUT);
}

void loop() {
  // on attend 2secondes avant notre première lecture
  // cela permet au module de charger correctement et cela évite des erreurs
  delay(2000);
  
  // lecture de l'humidité
  float h = dht.readHumidity(); 
  
  // lecture de la température en degré celsius (c'est l'option par défaut) 
  float t = dht.readTemperature(); 
  
  // petite vérification que l'on a bien une donnée.
  // isnan() permet de vérifier si la valeur n'est pas un nombre
  // dans notre cas si un des trois résultats n'est pas un nombre, on rentre dans la condition
  // une fois dans la condition, un petit message d'error et on arrête tout grâce au mot clé : return
  // on retourne sur le début de la boucle pour lire à nouveau les données
  // et si on n'a pas de données du capteur de température, on pense à enlever le courant du relais afin de couper le courant.
  if (isnan(h) || isnan(t)) {
    Serial.println("Erreur de lecture du capteur DHT !");
    digitalWrite(RELAY, LOW);
    return;
  }
  
  // si la température est égale ou inférieure à 20 (20°) on active le relais 
  if(t < 20){
    digitalWrite(RELAY, HIGH);
  } else {
    // sinon on l'éteint
    digitalWrite(RELAY, LOW);
  }

  // Pour le debug, on affiche les valeurs du capteur de températeur/humidité dans le moniteur de série
  // String() permet de convertir notre variable en string afin de pouvoir la concaténer sans souci 
  Serial.println("Humidité : " + String(h) + "%");
  Serial.println("Température : " + String(t) + "°C");
}
